<?php

    use App\SmBackgroundSetting;

    $setting = App\SmGeneralSettings::find(1);
    if (isset($setting->copyright_text)) {
        $copyright_text = $setting->copyright_text;
    } else {
        $copyright_text = 'Copyright © 2019 All rights reserved | This template is made with by Codethemes';
    }
    if (isset($setting->logo)) {
        $logo = $setting->logo;
    } else {
        $logo = 'public/uploads/settings/logo.png';
    }

    if (isset($setting->favicon)) {
        $favicon = $setting->favicon;
    } else {
        $favicon = 'public/backEnd/img/favicon.png';
    }

    // Login Background Setting
    $login_background = SmBackgroundSetting::where([['is_default', 1], ['title', 'Login Background']]);
    if (empty($login_background)) {
        $css = "background: url('public/backEnd/img/login-bg.jpg')  no-repeat center; background-size: cover; ";
    } else {
        if (!empty($login_background->image)) {
            $css = "background: url('" . $login_background->image . "')  no-repeat center;  background-size: cover;";
        } else {
            $css = "background:" . $login_background->color;
        }
    }
    // End Login Background Setting
?><!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <link rel="icon" href="{{asset($favicon)}}" type="image/png"/>
    <title>Login</title>
    <link rel="stylesheet" href="{{asset('public/backEnd/')}}/vendors/css/bootstrap.css"/>
    <link rel="stylesheet" href="{{asset('public/backEnd/')}}/vendors/css/themify-icons.css"/>
    <link rel="stylesheet" href="{{asset('public/backEnd/')}}/css/style.css"/>
</head>
<body class="login admin hight_100" style="{{$css}}">

<!--================ Start Login Area =================-->
<section class="login-area">
    <div class="container">
        <div class="row login-height justify-content-center align-items-center">
            <div class="col-lg-5 col-md-8">
                <div class="form-wrap text-center">
                    <div class="logo-container">
                        <a href="#">
                            <img src="{{asset('public/backEnd/img/logo.png')}}" alt="Logo Image" class="logoimage">
                        </a>
                    </div>
                    <h5 class="text-uppercase">Login Details</h5>
                    @if(session()->has('message-success') != "")
                        @if(session()->has('message-success'))
                            <p class="text-success">{{session()->get('message-success')}}</p>
                        @endif
                    @endif
                    @if(session()->has('message-danger') != "")
                        @if(session()->has('message-danger'))
                            <p class="text-danger">{{session()->get('message-danger')}}</p>
                        @endif
                    @endif
                    <form method="POST" class="" action="{{ route('login') }}">
                        @csrf
                        <div class="form-group input-group mb-4 mx-3">
								<span class="input-group-addon">
									<i class="ti-email"></i>
								</span>
                            <input class="form-control{{ $errors->has('email') ? ' is-invalid' : '' }}" type="email"
                                   name='email' placeholder="Enter Email address"/>
                            @if ($errors->has('email'))
                                <span class="invalid-feedback text-left pl-3" role="alert">
                                        <strong>{{ $errors->first('email') }}</strong>
                                    </span>
                            @endif
                        </div>

                        <div class="form-group input-group mb-4 mx-3">
								<span class="input-group-addon">
									<i class="ti-key"></i>
								</span>
                            <input class="form-control{{ $errors->has('password') ? ' is-invalid' : '' }}"
                                   type="password" name='password' placeholder="Enter Password"/>
                            @if ($errors->has('password'))
                                <span class="invalid-feedback text-left pl-3" role="alert">
                                        <strong>{{ $errors->first('password') }}</strong>
                                    </span>
                            @endif
                        </div>

                        <div class="d-flex justify-content-between pl-30">
                            <div class="checkbox">
                                <input class="form-check-input" type="checkbox" name="remember"
                                       id="rememberMe" {{ old('remember') ? 'checked' : '' }}>
                                <label for="rememberMe">Remember Me</label>
                            </div>
                            <div>
                                <a href="{{url('recovery/passord')}}">Forget Password?</a>
                            </div>
                        </div>

                        <div class="form-group mt-30 mb-30">
                            <button type="submit" class="primary-btn fix-gr-bg">
                                <span class="ti-lock mr-2"></span>
                                Login
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>
<!--================ Start End Login Area =================-->

<!--================ Footer Area =================-->
<footer class="footer_area">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-12 text-center">
                <p>Copyright © 2019 All rights reserved | This template is made with <span class="ti-heart"></span> by
                    Codethemes</p>
                </p>
            </div>
        </div>
    </div>
</footer>
<!--================ End Footer Area =================-->


<script src="{{asset('public/backEnd/')}}/vendors/js/jquery-3.2.1.min.js"></script>
<script src="{{asset('public/backEnd/')}}/vendors/js/popper.js"></script>
<script src="{{asset('public/backEnd/')}}/vendors/js/bootstrap.min.js"></script>

</body>
</html>
