<?php

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSmRolePermissionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sm_role_permissions', function (Blueprint $table) {
            $table->increments('id');
            $table->tinyInteger('active_status')->default(1);
            $table->timestamps();


            $table->integer('module_link_id')->nullable()->unsigned();
            $table->foreign('module_link_id')->references('id')->on('sm_module_links')->onDelete('RESTRICT');

            $table->integer('role_id')->nullable()->unsigned();
            $table->foreign('role_id')->references('id')->on('roles')->onDelete('RESTRICT');

            $table->integer('created_by')->nullable()->default(1)->unsigned();
            $table->foreign('created_by')->references('id')->on('users')->onDelete('RESTRICT');

            $table->integer('updated_by')->nullable()->default(1)->unsigned();
            $table->foreign('updated_by')->references('id')->on('users')->onDelete('RESTRICT');

            $table->integer('school_id')->nullable()->default(1)->unsigned();
            $table->foreign('school_id')->references('id')->on('sm_schools')->onDelete('RESTRICT');
        });
        // $sql="INSERT INTO sm_role_permissions (id, role_id, module_link_id, active_status, created_by, updated_by, created_at, updated_at) VALUES
        //     (1, 6, 25, 1, 1, 1, '2019-05-28 07:03:02', '2019-05-28 07:03:02'),
        //     (2, 6, 26, 1, 1, 1, '2019-05-28 07:03:02', '2019-05-28 07:03:02'),
        //     (3, 6, 27, 1, 1, 1, '2019-05-28 07:03:02', '2019-05-28 07:03:02'),
        //     (4, 6, 28, 1, 1, 1, '2019-05-28 07:03:02', '2019-05-28 07:03:02'),
        //     (5, 6, 29, 1, 1, 1, '2019-05-28 07:03:02', '2019-05-28 07:03:02'),
        //     (6, 6, 30, 1, 1, 1, '2019-05-28 07:03:02', '2019-05-28 07:03:02'),
        //     (7, 6, 31, 1, 1, 1, '2019-05-28 07:03:02', '2019-05-28 07:03:02'),
        //     (8, 6, 32, 1, 1, 1, '2019-05-28 07:03:02', '2019-05-28 07:03:02'),
        //     (9, 6, 33, 1, 1, 1, '2019-05-28 07:03:02', '2019-05-28 07:03:02'),
        //     (10, 6, 34, 1, 1, 1, '2019-05-28 07:03:02', '2019-05-28 07:03:02'),
        //     (11, 6, 35, 1, 1, 1, '2019-05-28 07:03:02', '2019-05-28 07:03:02'),
        //     (12, 6, 36, 1, 1, 1, '2019-05-28 07:03:02', '2019-05-28 07:03:02'),
        //     (13, 6, 37, 1, 1, 1, '2019-05-28 07:03:02', '2019-05-28 07:03:02'),
        //     (14, 6, 38, 1, 1, 1, '2019-05-28 07:03:02', '2019-05-28 07:03:02'),
        //     (15, 6, 39, 1, 1, 1, '2019-05-28 07:03:03', '2019-05-28 07:03:03'),
        //     (16, 6, 43, 1, 1, 1, '2019-05-28 07:03:03', '2019-05-28 07:03:03'),
        //     (17, 6, 44, 1, 1, 1, '2019-05-28 07:03:03', '2019-05-28 07:03:03'),
        //     (18, 6, 103, 1, 1, 1, '2019-05-28 07:03:03', '2019-05-28 07:03:03'),
        //     (19, 6, 104, 1, 1, 1, '2019-05-28 07:03:03', '2019-05-28 07:03:03'),
        //     (20, 6, 105, 1, 1, 1, '2019-05-28 07:03:03', '2019-05-28 07:03:03'),
        //     (21, 6, 119, 1, 1, 1, '2019-05-28 07:03:03', '2019-05-28 07:03:03'),
        //     (22, 5, 1, 1, 1, 1, '2019-05-28 08:41:58', '2019-05-28 08:41:58'),
        //     (23, 5, 2, 1, 1, 1, '2019-05-28 08:41:58', '2019-05-28 08:41:58'),
        //     (24, 5, 3, 1, 1, 1, '2019-05-28 08:41:58', '2019-05-28 08:41:58'),
        //     (25, 5, 4, 1, 1, 1, '2019-05-28 08:41:58', '2019-05-28 08:41:58'),
        //     (26, 5, 5, 1, 1, 1, '2019-05-28 08:41:58', '2019-05-28 08:41:58'),
        //     (27, 5, 6, 1, 1, 1, '2019-05-28 08:41:58', '2019-05-28 08:41:58'),
        //     (28, 5, 7, 1, 1, 1, '2019-05-28 08:41:58', '2019-05-28 08:41:58'),
        //     (29, 5, 8, 1, 1, 1, '2019-05-28 08:41:58', '2019-05-28 08:41:58'),
        //     (30, 5, 9, 1, 1, 1, '2019-05-28 08:41:58', '2019-05-28 08:41:58'),
        //     (31, 5, 10, 1, 1, 1, '2019-05-28 08:41:58', '2019-05-28 08:41:58'),
        //     (32, 5, 11, 1, 1, 1, '2019-05-28 08:41:58', '2019-05-28 08:41:58'),
        //     (33, 5, 12, 1, 1, 1, '2019-05-28 08:41:58', '2019-05-28 08:41:58'),
        //     (34, 5, 13, 1, 1, 1, '2019-05-28 08:41:59', '2019-05-28 08:41:59'),
        //     (35, 5, 14, 1, 1, 1, '2019-05-28 08:41:59', '2019-05-28 08:41:59'),
        //     (36, 5, 15, 1, 1, 1, '2019-05-28 08:41:59', '2019-05-28 08:41:59'),
        //     (37, 5, 16, 1, 1, 1, '2019-05-28 08:41:59', '2019-05-28 08:41:59'),
        //     (38, 5, 17, 1, 1, 1, '2019-05-28 08:41:59', '2019-05-28 08:41:59'),
        //     (39, 5, 18, 1, 1, 1, '2019-05-28 08:41:59', '2019-05-28 08:41:59'),
        //     (40, 5, 19, 1, 1, 1, '2019-05-28 08:41:59', '2019-05-28 08:41:59'),
        //     (41, 5, 20, 1, 1, 1, '2019-05-28 08:41:59', '2019-05-28 08:41:59'),
        //     (42, 5, 21, 1, 1, 1, '2019-05-28 08:41:59', '2019-05-28 08:41:59'),
        //     (43, 5, 22, 1, 1, 1, '2019-05-28 08:41:59', '2019-05-28 08:41:59'),
        //     (44, 5, 23, 1, 1, 1, '2019-05-28 08:41:59', '2019-05-28 08:41:59'),
        //     (45, 5, 24, 1, 1, 1, '2019-05-28 08:41:59', '2019-05-28 08:41:59'),
        //     (46, 5, 25, 1, 1, 1, '2019-05-28 08:41:59', '2019-05-28 08:41:59'),
        //     (47, 5, 26, 1, 1, 1, '2019-05-28 08:41:59', '2019-05-28 08:41:59'),
        //     (48, 5, 27, 1, 1, 1, '2019-05-28 08:41:59', '2019-05-28 08:41:59'),
        //     (49, 5, 28, 1, 1, 1, '2019-05-28 08:41:59', '2019-05-28 08:41:59'),
        //     (50, 5, 29, 1, 1, 1, '2019-05-28 08:41:59', '2019-05-28 08:41:59'),
        //     (51, 5, 30, 1, 1, 1, '2019-05-28 08:42:00', '2019-05-28 08:42:00'),
        //     (52, 5, 31, 1, 1, 1, '2019-05-28 08:42:00', '2019-05-28 08:42:00'),
        //     (53, 5, 32, 1, 1, 1, '2019-05-28 08:42:00', '2019-05-28 08:42:00'),
        //     (54, 5, 33, 1, 1, 1, '2019-05-28 08:42:00', '2019-05-28 08:42:00'),
        //     (55, 5, 34, 1, 1, 1, '2019-05-28 08:42:00', '2019-05-28 08:42:00'),
        //     (56, 5, 35, 1, 1, 1, '2019-05-28 08:42:00', '2019-05-28 08:42:00'),
        //     (57, 5, 36, 1, 1, 1, '2019-05-28 08:42:00', '2019-05-28 08:42:00'),
        //     (58, 5, 37, 1, 1, 1, '2019-05-28 08:42:00', '2019-05-28 08:42:00'),
        //     (59, 5, 38, 1, 1, 1, '2019-05-28 08:42:00', '2019-05-28 08:42:00'),
        //     (60, 5, 39, 1, 1, 1, '2019-05-28 08:42:00', '2019-05-28 08:42:00'),
        //     (61, 5, 40, 1, 1, 1, '2019-05-28 08:42:00', '2019-05-28 08:42:00'),
        //     (62, 5, 41, 1, 1, 1, '2019-05-28 08:42:00', '2019-05-28 08:42:00'),
        //     (63, 5, 42, 1, 1, 1, '2019-05-28 08:42:00', '2019-05-28 08:42:00'),
        //     (64, 5, 43, 1, 1, 1, '2019-05-28 08:42:00', '2019-05-28 08:42:00'),
        //     (65, 5, 44, 1, 1, 1, '2019-05-28 08:42:00', '2019-05-28 08:42:00'),
        //     (66, 5, 45, 1, 1, 1, '2019-05-28 08:42:00', '2019-05-28 08:42:00'),
        //     (67, 5, 46, 1, 1, 1, '2019-05-28 08:42:00', '2019-05-28 08:42:00'),
        //     (68, 5, 47, 1, 1, 1, '2019-05-28 08:42:01', '2019-05-28 08:42:01'),
        //     (69, 5, 48, 1, 1, 1, '2019-05-28 08:42:01', '2019-05-28 08:42:01'),
        //     (70, 5, 49, 1, 1, 1, '2019-05-28 08:42:01', '2019-05-28 08:42:01'),
        //     (71, 5, 50, 1, 1, 1, '2019-05-28 08:42:01', '2019-05-28 08:42:01'),
        //     (72, 5, 51, 1, 1, 1, '2019-05-28 08:42:01', '2019-05-28 08:42:01'),
        //     (73, 5, 52, 1, 1, 1, '2019-05-28 08:42:01', '2019-05-28 08:42:01'),
        //     (74, 5, 53, 1, 1, 1, '2019-05-28 08:42:01', '2019-05-28 08:42:01'),
        //     (75, 5, 54, 1, 1, 1, '2019-05-28 08:42:01', '2019-05-28 08:42:01'),
        //     (76, 5, 55, 1, 1, 1, '2019-05-28 08:42:01', '2019-05-28 08:42:01'),
        //     (77, 5, 56, 1, 1, 1, '2019-05-28 08:42:01', '2019-05-28 08:42:01'),
        //     (78, 5, 57, 1, 1, 1, '2019-05-28 08:42:01', '2019-05-28 08:42:01'),
        //     (79, 5, 58, 1, 1, 1, '2019-05-28 08:42:01', '2019-05-28 08:42:01'),
        //     (80, 5, 59, 1, 1, 1, '2019-05-28 08:42:01', '2019-05-28 08:42:01'),
        //     (81, 5, 60, 1, 1, 1, '2019-05-28 08:42:01', '2019-05-28 08:42:01'),
        //     (82, 5, 61, 1, 1, 1, '2019-05-28 08:42:01', '2019-05-28 08:42:01'),
        //     (83, 5, 62, 1, 1, 1, '2019-05-28 08:42:01', '2019-05-28 08:42:01'),
        //     (84, 5, 63, 1, 1, 1, '2019-05-28 08:42:01', '2019-05-28 08:42:01'),
        //     (85, 5, 64, 1, 1, 1, '2019-05-28 08:42:01', '2019-05-28 08:42:01'),
        //     (86, 5, 65, 1, 1, 1, '2019-05-28 08:42:01', '2019-05-28 08:42:01'),
        //     (87, 5, 66, 1, 1, 1, '2019-05-28 08:42:02', '2019-05-28 08:42:02'),
        //     (88, 5, 67, 1, 1, 1, '2019-05-28 08:42:02', '2019-05-28 08:42:02'),
        //     (89, 5, 68, 1, 1, 1, '2019-05-28 08:42:02', '2019-05-28 08:42:02'),
        //     (90, 5, 72, 1, 1, 1, '2019-05-28 08:42:02', '2019-05-28 08:42:02'),
        //     (91, 5, 73, 1, 1, 1, '2019-05-28 08:42:02', '2019-05-28 08:42:02'),
        //     (92, 5, 74, 1, 1, 1, '2019-05-28 08:42:02', '2019-05-28 08:42:02'),
        //     (93, 5, 75, 1, 1, 1, '2019-05-28 08:42:02', '2019-05-28 08:42:02'),
        //     (94, 5, 76, 1, 1, 1, '2019-05-28 08:42:02', '2019-05-28 08:42:02'),
        //     (95, 5, 77, 1, 1, 1, '2019-05-28 08:42:02', '2019-05-28 08:42:02'),
        //     (96, 5, 78, 1, 1, 1, '2019-05-28 08:42:02', '2019-05-28 08:42:02'),
        //     (97, 5, 79, 1, 1, 1, '2019-05-28 08:42:02', '2019-05-28 08:42:02'),
        //     (98, 5, 80, 1, 1, 1, '2019-05-28 08:42:02', '2019-05-28 08:42:02'),
        //     (99, 5, 81, 1, 1, 1, '2019-05-28 08:42:02', '2019-05-28 08:42:02'),
        //     (100, 5, 82, 1, 1, 1, '2019-05-28 08:42:02', '2019-05-28 08:42:02'),
        //     (101, 5, 83, 1, 1, 1, '2019-05-28 08:42:02', '2019-05-28 08:42:02'),
        //     (102, 5, 84, 1, 1, 1, '2019-05-28 08:42:03', '2019-05-28 08:42:03'),
        //     (103, 5, 85, 1, 1, 1, '2019-05-28 08:42:03', '2019-05-28 08:42:03'),
        //     (104, 5, 86, 1, 1, 1, '2019-05-28 08:42:03', '2019-05-28 08:42:03'),
        //     (105, 5, 87, 1, 1, 1, '2019-05-28 08:42:03', '2019-05-28 08:42:03'),
        //     (106, 5, 88, 1, 1, 1, '2019-05-28 08:42:03', '2019-05-28 08:42:03'),
        //     (107, 5, 89, 1, 1, 1, '2019-05-28 08:42:03', '2019-05-28 08:42:03'),
        //     (108, 5, 90, 1, 1, 1, '2019-05-28 08:42:03', '2019-05-28 08:42:03'),
        //     (109, 5, 91, 1, 1, 1, '2019-05-28 08:42:03', '2019-05-28 08:42:03'),
        //     (110, 5, 92, 1, 1, 1, '2019-05-28 08:42:03', '2019-05-28 08:42:03'),
        //     (111, 5, 93, 1, 1, 1, '2019-05-28 08:42:03', '2019-05-28 08:42:03'),
        //     (112, 5, 94, 1, 1, 1, '2019-05-28 08:42:03', '2019-05-28 08:42:03'),
        //     (113, 5, 95, 1, 1, 1, '2019-05-28 08:42:03', '2019-05-28 08:42:03'),
        //     (114, 5, 96, 1, 1, 1, '2019-05-28 08:42:03', '2019-05-28 08:42:03'),
        //     (115, 5, 97, 1, 1, 1, '2019-05-28 08:42:03', '2019-05-28 08:42:03'),
        //     (116, 5, 98, 1, 1, 1, '2019-05-28 08:42:03', '2019-05-28 08:42:03'),
        //     (117, 5, 99, 1, 1, 1, '2019-05-28 08:42:03', '2019-05-28 08:42:03'),
        //     (118, 5, 100, 1, 1, 1, '2019-05-28 08:42:03', '2019-05-28 08:42:03'),
        //     (119, 5, 101, 1, 1, 1, '2019-05-28 08:42:03', '2019-05-28 08:42:03'),
        //     (120, 5, 102, 1, 1, 1, '2019-05-28 08:42:04', '2019-05-28 08:42:04'),
        //     (121, 5, 103, 1, 1, 1, '2019-05-28 08:42:04', '2019-05-28 08:42:04'),
        //     (122, 5, 104, 1, 1, 1, '2019-05-28 08:42:04', '2019-05-28 08:42:04'),
        //     (123, 5, 105, 1, 1, 1, '2019-05-28 08:42:04', '2019-05-28 08:42:04'),
        //     (124, 5, 106, 1, 1, 1, '2019-05-28 08:42:04', '2019-05-28 08:42:04'),
        //     (125, 5, 107, 1, 1, 1, '2019-05-28 08:42:04', '2019-05-28 08:42:04'),
        //     (126, 5, 108, 1, 1, 1, '2019-05-28 08:42:04', '2019-05-28 08:42:04'),
        //     (127, 5, 109, 1, 1, 1, '2019-05-28 08:42:04', '2019-05-28 08:42:04'),
        //     (128, 5, 110, 1, 1, 1, '2019-05-28 08:42:04', '2019-05-28 08:42:04'),
        //     (129, 5, 111, 1, 1, 1, '2019-05-28 08:42:04', '2019-05-28 08:42:04'),
        //     (130, 5, 112, 1, 1, 1, '2019-05-28 08:42:04', '2019-05-28 08:42:04'),
        //     (131, 5, 113, 1, 1, 1, '2019-05-28 08:42:04', '2019-05-28 08:42:04'),
        //     (132, 5, 114, 1, 1, 1, '2019-05-28 08:42:04', '2019-05-28 08:42:04'),
        //     (133, 5, 115, 1, 1, 1, '2019-05-28 08:42:04', '2019-05-28 08:42:04'),
        //     (134, 5, 116, 1, 1, 1, '2019-05-28 08:42:04', '2019-05-28 08:42:04'),
        //     (135, 5, 117, 1, 1, 1, '2019-05-28 08:42:04', '2019-05-28 08:42:04'),
        //     (136, 5, 118, 1, 1, 1, '2019-05-28 08:42:05', '2019-05-28 08:42:05'),
        //     (137, 5, 119, 1, 1, 1, '2019-05-28 08:42:05', '2019-05-28 08:42:05'),
        //     (138, 5, 121, 1, 1, 1, '2019-05-28 08:42:05', '2019-05-28 08:42:05'),
        //     (139, 5, 122, 1, 1, 1, '2019-05-28 08:42:05', '2019-05-28 08:42:05'),
        //     (140, 5, 123, 1, 1, 1, '2019-05-28 08:42:05', '2019-05-28 08:42:05'),
        //     (141, 5, 124, 1, 1, 1, '2019-05-28 08:42:05', '2019-05-28 08:42:05'),
        //     (142, 5, 125, 1, 1, 1, '2019-05-28 08:42:05', '2019-05-28 08:42:05'),
        //     (143, 5, 126, 1, 1, 1, '2019-05-28 08:42:05', '2019-05-28 08:42:05'),
        //     (144, 5, 127, 1, 1, 1, '2019-05-28 08:42:05', '2019-05-28 08:42:05'),
        //     (164, 4, 1, 1, 1, 1, '2019-05-28 08:48:01', '2019-05-28 08:48:01'),
        //     (165, 4, 12, 1, 1, 1, '2019-05-28 08:48:01', '2019-05-28 08:48:01'),
        //     (166, 4, 13, 1, 1, 1, '2019-05-28 08:48:01', '2019-05-28 08:48:01'),
        //     (167, 4, 20, 1, 1, 1, '2019-05-28 08:48:01', '2019-05-28 08:48:01'),
        //     (168, 4, 21, 1, 1, 1, '2019-05-28 08:48:01', '2019-05-28 08:48:01'),
        //     (169, 4, 22, 1, 1, 1, '2019-05-28 08:48:01', '2019-05-28 08:48:01'),
        //     (170, 4, 23, 1, 1, 1, '2019-05-28 08:48:01', '2019-05-28 08:48:01'),
        //     (171, 4, 24, 1, 1, 1, '2019-05-28 08:48:01', '2019-05-28 08:48:01'),
        //     (172, 4, 47, 1, 1, 1, '2019-05-28 08:48:01', '2019-05-28 08:48:01'),
        //     (173, 4, 48, 1, 1, 1, '2019-05-28 08:48:01', '2019-05-28 08:48:01'),
        //     (174, 4, 49, 1, 1, 1, '2019-05-28 08:48:01', '2019-05-28 08:48:01'),
        //     (175, 4, 50, 1, 1, 1, '2019-05-28 08:48:01', '2019-05-28 08:48:01'),
        //     (176, 4, 51, 1, 1, 1, '2019-05-28 08:48:01', '2019-05-28 08:48:01'),
        //     (177, 4, 53, 1, 1, 1, '2019-05-28 08:48:01', '2019-05-28 08:48:01'),
        //     (178, 4, 60, 1, 1, 1, '2019-05-28 08:48:01', '2019-05-28 08:48:01'),
        //     (179, 4, 61, 1, 1, 1, '2019-05-28 08:48:01', '2019-05-28 08:48:01'),
        //     (180, 4, 62, 1, 1, 1, '2019-05-28 08:48:02', '2019-05-28 08:48:02'),
        //     (181, 4, 63, 1, 1, 1, '2019-05-28 08:48:02', '2019-05-28 08:48:02'),
        //     (182, 4, 64, 1, 1, 1, '2019-05-28 08:48:02', '2019-05-28 08:48:02'),
        //     (183, 4, 65, 1, 1, 1, '2019-05-28 08:48:02', '2019-05-28 08:48:02'),
        //     (184, 4, 66, 1, 1, 1, '2019-05-28 08:48:02', '2019-05-28 08:48:02'),
        //     (185, 4, 67, 1, 1, 1, '2019-05-28 08:48:02', '2019-05-28 08:48:02'),
        //     (186, 4, 68, 1, 1, 1, '2019-05-28 08:48:02', '2019-05-28 08:48:02'),
        //     (187, 4, 69, 1, 1, 1, '2019-05-28 08:48:02', '2019-05-28 08:48:02'),
        //     (188, 4, 70, 1, 1, 1, '2019-05-28 08:48:02', '2019-05-28 08:48:02'),
        //     (189, 4, 71, 1, 1, 1, '2019-05-28 08:48:02', '2019-05-28 08:48:02'),
        //     (190, 4, 72, 1, 1, 1, '2019-05-28 08:48:02', '2019-05-28 08:48:02'),
        //     (191, 4, 78, 1, 1, 1, '2019-05-28 08:48:02', '2019-05-28 08:48:02'),
        //     (192, 4, 84, 1, 1, 1, '2019-05-28 08:48:02', '2019-05-28 08:48:02'),
        //     (193, 4, 91, 1, 1, 1, '2019-05-28 08:48:02', '2019-05-28 08:48:02'),
        //     (194, 4, 92, 1, 1, 1, '2019-05-28 08:48:03', '2019-05-28 08:48:03'),
        //     (195, 4, 93, 1, 1, 1, '2019-05-28 08:48:03', '2019-05-28 08:48:03'),
        //     (196, 4, 94, 1, 1, 1, '2019-05-28 08:48:03', '2019-05-28 08:48:03'),
        //     (197, 4, 109, 1, 1, 1, '2019-05-28 08:48:03', '2019-05-28 08:48:03'),
        //     (198, 7, 1, 1, 1, 1, '2019-05-28 08:49:14', '2019-05-28 08:49:14'),
        //     (199, 7, 2, 1, 1, 1, '2019-05-28 08:49:14', '2019-05-28 08:49:14'),
        //     (200, 7, 3, 1, 1, 1, '2019-05-28 08:49:14', '2019-05-28 08:49:14'),
        //     (201, 7, 4, 1, 1, 1, '2019-05-28 08:49:14', '2019-05-28 08:49:14'),
        //     (202, 7, 5, 1, 1, 1, '2019-05-28 08:49:15', '2019-05-28 08:49:15'),
        //     (203, 7, 6, 1, 1, 1, '2019-05-28 08:49:15', '2019-05-28 08:49:15'),
        //     (204, 7, 7, 1, 1, 1, '2019-05-28 08:49:15', '2019-05-28 08:49:15'),
        //     (205, 7, 8, 1, 1, 1, '2019-05-28 08:49:15', '2019-05-28 08:49:15'),
        //     (206, 7, 9, 1, 1, 1, '2019-05-28 08:49:15', '2019-05-28 08:49:15'),
        //     (207, 7, 10, 1, 1, 1, '2019-05-28 08:49:15', '2019-05-28 08:49:15'),
        //     (208, 7, 11, 1, 1, 1, '2019-05-28 08:49:15', '2019-05-28 08:49:15'),
        //     (209, 7, 12, 1, 1, 1, '2019-05-28 08:49:15', '2019-05-28 08:49:15'),
        //     (210, 7, 13, 1, 1, 1, '2019-05-28 08:49:15', '2019-05-28 08:49:15'),
        //     (211, 7, 40, 1, 1, 1, '2019-05-28 08:49:15', '2019-05-28 08:49:15'),
        //     (212, 7, 47, 1, 1, 1, '2019-05-28 08:49:15', '2019-05-28 08:49:15'),
        //     (213, 7, 48, 1, 1, 1, '2019-05-28 08:49:15', '2019-05-28 08:49:15'),
        //     (214, 7, 49, 1, 1, 1, '2019-05-28 08:49:15', '2019-05-28 08:49:15'),
        //     (215, 7, 50, 1, 1, 1, '2019-05-28 08:49:15', '2019-05-28 08:49:15'),
        //     (216, 8, 47, 1, 1, 1, '2019-05-28 08:50:12', '2019-05-28 08:50:12'),
        //     (217, 8, 48, 1, 1, 1, '2019-05-28 08:50:12', '2019-05-28 08:50:12'),
        //     (218, 8, 49, 1, 1, 1, '2019-05-28 08:50:12', '2019-05-28 08:50:12'),
        //     (219, 8, 50, 1, 1, 1, '2019-05-28 08:50:12', '2019-05-28 08:50:12'),
        //     (220, 8, 77, 1, 1, 1, '2019-05-28 08:50:12', '2019-05-28 08:50:12'),
        //     (221, 8, 78, 1, 1, 1, '2019-05-28 08:50:12', '2019-05-28 08:50:12'),
        //     (222, 8, 79, 1, 1, 1, '2019-05-28 08:50:12', '2019-05-28 08:50:12'),
        //     (223, 8, 80, 1, 1, 1, '2019-05-28 08:50:12', '2019-05-28 08:50:12'),
        //     (224, 8, 81, 1, 1, 1, '2019-05-28 08:50:12', '2019-05-28 08:50:12'),
        //     (225, 8, 82, 1, 1, 1, '2019-05-28 08:50:12', '2019-05-28 08:50:12')";

        // DB::insert($sql);
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sm_role_permissions');
    }
}
