<?php

namespace App\Http\Controllers\api;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use App\SmSmsGateway;
use App\SmStudentAttendance;
use illuminate\Support\Carbon;
use App\SmStudent;

class BiometricController extends Controller
{
    public function sendSMS(Request $request){
        
        // $info = $request->data;
        
        // $student_id = $info['empid'];
        $check = DB::table('sm_students')->where('id',$request->student_id)->first();
        $to_mobile = $check->mobile;
        

        if($check == null){
            return response()->json(['success'=>false,'message'=> 'Student id not found']);
        }
        else{

            $date = Carbon::now();
            $newDate = Carbon::createFromFormat('Y-m-d H:i:s', $date)->format('Y-m-d');

            SmStudentAttendance::insert([
                'attendance_type' => "P",
                'notes'           => "Sample Attendance",
                'attendance_date' => $newDate,
                'created_at'      => $newDate,
                'student_id'      => $student_id,
                'created_by'      => $check->created_by,
                'updated_by'      => $check->updated_by,
                'school_id'       => $check->school_id
            ]);

            $sms = $check->full_name." has entered in the classroom at ".$date;

            $activeSmsGateway = SmSmsGateway::where('active_status', '=', 1)->first();

            $msg91_authentication_key_sid   = $activeSmsGateway->msg91_authentication_key_sid;
            $msg91_sender_id                = $activeSmsGateway->msg91_sender_id;
            $msg91_route                    = $activeSmsGateway->msg91_route;
            $msg91_country_code             = $activeSmsGateway->msg91_country_code;

            $curl = curl_init();
            
            // $url = "https://api.msg91.com/api/sendhttp.php?mobiles=".$to_mobile."&authkey=".$msg91_authentication_key_sid."&route=".$msg91_route."&sender=".$msg91_sender_id."&message=".$sms."&country=91";
            $url = "http://world.msg91.com/api/sendhttp.php?authkey=".$msg91_authentication_key_sid."&mobiles=".$to_mobile."&message=".$sms."&sender=".$msg91_sender_id."&route=".$msg91_route."&country=".$msg91_country_code;

            curl_setopt_array($curl, array(
                CURLOPT_URL => $url,
                CURLOPT_RETURNTRANSFER => true, CURLOPT_ENCODING => "", CURLOPT_MAXREDIRS => 10, CURLOPT_TIMEOUT => 30, CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1, CURLOPT_CUSTOMREQUEST => "GET", CURLOPT_SSL_VERIFYHOST => 0, CURLOPT_SSL_VERIFYPEER => 0,
            ));
            $response = curl_exec($curl);
            $err = curl_error($curl);
            curl_close($curl);
            if ($err) {
                $result =  "cURL Error #:" . $err;
            } else { 
                $result =  $response;
            }

            return response()->json(['success'=>True,'message'=> 'Message has been sent']);
        }
    }
}
