<?php

namespace App\Http\Controllers;

use App\ApiBaseMethod;
use Illuminate\Http\Request;
use App\SmClass;
use App\SmStudent;
use App\SmStudentAttendance;
use Validator;
use Excel;
use App\SmSmsGateway;
use Twilio;
use Clickatell\Rest;
use Clickatell\ClickatellException;
use App\SmEmailSmsLog; 
use App\SmGeneralSettings;
use LaravelMsg91; 

class SmStudentAttendanceController extends Controller
{
    public function __construct()
    {
        $this->middleware('PM');
    }
    
    public function index(Request $request){
    	$classes = SmClass::where('active_status', 1)->get();

        if (ApiBaseMethod::checkUrl($request->fullUrl())) {
            return ApiBaseMethod::sendResponse($classes, null);
        }
    	return view('backEnd.studentInformation.student_attendance', compact('classes'));
    }

    public function studentSearch(Request $request){
        $input = $request->all();
        $validator = Validator::make($input, [
            'class' => 'required',
            'section' => 'required',
            'attendance_date' => 'required'
        ]);

        if ($validator->fails()) {
            if (ApiBaseMethod::checkUrl($request->fullUrl())) {
                return ApiBaseMethod::sendError('Validation Error.', $validator->errors());
            }
            return redirect()->back()
                ->withErrors($validator)
                ->withInput();
        }

    	$date = $request->attendance_date;
    	$classes = SmClass::where('active_status', 1)->get();



    	$students = SmStudent::where('class_id', $request->class)->where('section_id', $request->section)->where('active_status', 1)->get();

        if($students->isEmpty()){
            return redirect('student-attendance')->with('message-danger', 'No result found');
        }

        $already_assigned_students = [];
        $new_students = [];
        $attendance_type = "";
        foreach($students as $student){
            $attendance = SmStudentAttendance::where('student_id', $student->id)->where('attendance_date', date('Y-m-d', strtotime($request->attendance_date)))->first();

            if($attendance != ""){
                $already_assigned_students[] = $attendance;
                $attendance_type =  $attendance->attendance_type;
            }else{
                $new_students[] =  $student;
            }
        }

        $class_id = $request->class;

        if (ApiBaseMethod::checkUrl($request->fullUrl())) {
            $data = [];
            $data['classes'] = $classes->toArray();
            $data['date'] = $date;
            $data['class_id'] = $class_id;
            $data['already_assigned_students'] = $already_assigned_students;
            $data['new_students'] = $new_students;
            $data['attendance_type'] = $attendance_type;
            return ApiBaseMethod::sendResponse($data, null);
        }
    	return view('backEnd.studentInformation.student_attendance', compact('classes', 'date', 'class_id', 'date', 'already_assigned_students', 'new_students', 'attendance_type'));
    }

    public function studentAttendanceStore(Request $request){

        if($request->file('attn-file')) {return $this->attendanceBulkStore($request);}

    	foreach($request->id as $student){
            $attendance = SmStudentAttendance::where('student_id', $student)->where('attendance_date', date('Y-m-d', strtotime($request->date)))->first();

            if($attendance != ""){
                $attendance->delete();
            }

        $studentDetails = SmStudent::select('full_name', 'mobile')->where([['id',$student],['active_status', 1]])->first(); 

        $to_name = $studentDetails->full_name;
        $to_mobile = $studentDetails->mobile;
        $sms = $to_name.' is ';

    		$attendance = new SmStudentAttendance();
    		$attendance->student_id = $student;
            if(isset($request->mark_holiday)){
                $attendance->attendance_type = "H";
            }else{
               $attendance->attendance_type = $request->attendance[$student];
               $attendance->notes = $request->note[$student]; 

               if($attendance->attendance_type == 'P'){ $sms.='present';}
               else if($attendance->attendance_type == 'A'){ $sms.='absent';}

               $this->sendSMSFromComunicate($to_mobile,$sms);
            }
    		$attendance->attendance_date = date('Y-m-d', strtotime($request->date));
    		$attendance->save();
    	}

        if (ApiBaseMethod::checkUrl($request->fullUrl())) {
            return ApiBaseMethod::sendResponse(null, 'Student attendance been submitted successfully');
        }
    	return redirect('student-attendance')->with('message-success', 'Student attendance been submitted successfully');
    }


    public function studentAttendanceHoliday(Request $request){
    	dd($request->all());
    }


public function attendanceBulkStore(Request $request){

          $path = $request->file('attn-file')->getRealPath();         
          try{
           $data = \Excel::load($path)->get();
          }
          catch(\EXCEPTION $e)
          {
            return $e->getMessage();
          }      

        if($data->count()){

            foreach ($data as $key => $value) {

         $class_id = $value->class_id;     
         $sec_id = $value->sec_id;     
         $roll_no = $value->roll_no;     
         $att_type = $value->att_type;      
         $att_date = $value->att_date;      
         $notes = $value->notes;

$studentDetails = SmStudent::where([['class_id',$class_id],['section_id',$sec_id],['roll_no',$roll_no],['active_status', 1]])->first(); 
$student_id = $studentDetails->id;

$attendance = SmStudentAttendance::where('student_id', $student_id)->where('attendance_date', date('Y-m-d', strtotime($att_date)))->first();

            if($attendance != ""){
                $attendance->delete();
            }

        $to_name = $studentDetails->full_name;
        $to_mobile = $studentDetails->mobile;
        $sms = $to_name.' is ';

                    $attendance = new SmStudentAttendance();
                    // $student->siblings_id = $value->sibling_id;
                    $attendance->attendance_type = $att_type;
                    $attendance->notes = $notes;
                    $attendance->attendance_date = $att_date;
                    $attendance->student_id = $student_id;

                    $attendance->save();

               if($attendance->attendance_type == 'P'){ $sms.='present';}
               else if($attendance->attendance_type == 'A'){ $sms.='absent';}

               $this->sendSMSFromComunicate($to_mobile,$sms);
                     
                }               
            }

            return redirect()->back()->with('message-success', 'Bulk attendance has been created successfully');
    } 

public function sendSMSFromComunicate($to_mobile, $sms){
    $activeSmsGateway = SmSmsGateway::where('active_status', '=', 1)->first();

    if ($activeSmsGateway->gateway_name == 'Twilio') {
        $account_id         = $activeSmsGateway->twilio_account_sid; // Your Account SID from www.twilio.com/console
        $auth_token         = $activeSmsGateway->twilio_authentication_token; // Your Auth Token from www.twilio.com/console
        $from_phone_number  = $activeSmsGateway->twilio_registered_no;

        $client = new Twilio\Rest\Client($account_id, $auth_token);
        if(!empty($to_mobile)){
            $result = $message = $client->messages->create( $to_mobile, array( 'from' => $from_phone_number,  'body' => $sms ) );
        }
    }//end Twilio
    else if($activeSmsGateway->gateway_name == 'Clickatell'){
        config(['clickatell.api_key' => $smsGatewayDetails->clickatell_api_id]); //set a variale in config file(clickatell.php)
        $clickatell = new \Clickatell\Rest();
        $result = $clickatell->sendMessage([ 'to' => [$to_mobile],  'content' => $sms]); 
    }//end Clickatell

    else if($activeSmsGateway->gateway_name == 'Msg91'){
        $msg91_authentication_key_sid   = $activeSmsGateway->msg91_authentication_key_sid;
        $msg91_sender_id                = $activeSmsGateway->msg91_sender_id;
        $msg91_route                    = $activeSmsGateway->msg91_route;
        $msg91_country_code             = $activeSmsGateway->msg91_country_code;

        $curl = curl_init();


        
        // $url = "https://api.msg91.com/api/sendhttp.php?mobiles=".$to_mobile."&authkey=".$msg91_authentication_key_sid."&route=".$msg91_route."&sender=".$msg91_sender_id."&message=".$sms."&country=91";        
        $url = "http://world.msg91.com/api/sendhttp.php?authkey=".$msg91_authentication_key_sid."&mobiles=".$to_mobile."&message=".$sms."&sender=".$msg91_sender_id."&route=".$msg91_route."&country=".$msg91_country_code;

        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true, CURLOPT_ENCODING => "", CURLOPT_MAXREDIRS => 10, CURLOPT_TIMEOUT => 30, CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1, CURLOPT_CUSTOMREQUEST => "GET", CURLOPT_SSL_VERIFYHOST => 0, CURLOPT_SSL_VERIFYPEER => 0,
        ));
        $response = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);
        if ($err) {
            $result =  "cURL Error #:" . $err;
        } else { 
            $result =  $response;
        }
    }//end Msg91

    return $result;

}
   
}
