<?php

namespace App\Http\Controllers\teacher;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\SmAssignSubject;
use App\SmClassRoutine;
use App\SmClassTime;
use App\SmWeekend;
use App\SmStaff;
use App\SmStudent;
use App\SmClass;
use App\SmSection;
use App\SmHomework;
use App\Staff;
use App\SmStaffAttendence;

use DB;
use Auth;
use Validator;
use App\ApiBaseMethod;

class SmAcademicsController extends Controller
{
    public function viewTeacherRoutine(){

    	// $assinged_subjects = SmAssignSubject::where('active_status', 1)->where('teacher_id', 4)->distinct()->get(['subject_id']);

    	// $class_routines = [];
    	// foreach($assinged_subjects as $assinged_subject){
    	// 	$class_routines[] = SmClassRoutine::where('subject_id', $assinged_subject->subject_id)->first();
    	// }
        $user = Auth::user();

    	$class_times = SmClassTime::all();
    	$teacher_id = $user->staff->id;

        $sm_weekends = SmWeekend::orderBy('order', 'ASC')->where('active_status', 1)->get();
        $teachers = SmStaff::select('id', 'full_name')->where('active_status', 1)->get();

    	return view('backEnd.teacherPanel.view_class_routine', compact('class_times', 'teacher_id', 'sm_weekends', 'teachers'));

	}
	
	public function searchStudent(Request $request){
		
		
        $class_id = $request->class;
        $section_id = $request->section;
        $name = $request->name;
		$roll_no = $request->roll_no;
		
			
		
			$students='';
			$msg='';
		
		if(!empty($request->class) && !empty($request->section)){
			$students=DB::table('sm_students')
			->select('student_photo','full_name','roll_no','class_name','section_name','user_id' )
			->join('sm_sections','sm_sections.id','=','sm_students.section_id' )
			->join('sm_classes','sm_classes.id','=','sm_students.class_id' )
			->where('sm_students.class_id',$request->class)
			->where('sm_students.section_id',$request->section)
			->get();
			$msg="Student Found";
		}elseif (!empty($request->class)) {
			$students=DB::table('sm_students')
			->select('student_photo','full_name','roll_no','class_name','section_name','user_id' )
			->join('sm_sections','sm_sections.id','=','sm_students.section_id' )
			->join('sm_classes','sm_classes.id','=','sm_students.class_id' )
			->where('sm_students.class_id',$class_id)
			// ->where('section_id',$section_id)
			->get();
			$msg="Student Found";
		}elseif($request->name != ""){
			$students=DB::table('sm_students')
			->select('student_photo','full_name','roll_no','class_name','section_name','user_id' )
			->join('sm_sections','sm_sections.id','=','sm_students.section_id' )
			->join('sm_classes','sm_classes.id','=','sm_students.class_id' )	
			->where('full_name', 'like', '%'.$request->name.'%')
			->first();
			$msg="Student Found";
		}elseif($request->roll_no != ""){
			$students=DB::table('sm_students')
			->select('student_photo','full_name','roll_no','class_name','section_name','user_id' )
			->join('sm_sections','sm_sections.id','=','sm_students.section_id' )
			->join('sm_classes','sm_classes.id','=','sm_students.class_id' )
			->where('roll_no', 'like', '%'.$request->roll_no.'%')
			->first();
			$msg="Student Found";
		}else{
			
			$msg="Student Not Found";
		}

		
		
        if (ApiBaseMethod::checkUrl($request->fullUrl())) {
            $data = [];
            $data['students'] = $students;
            
            return ApiBaseMethod::sendResponse($data, $msg);
        }
	}
	public function myRoutine(Request $request, $id){
		$teacher=DB::table('sm_staffs')
		->where('user_id','=',$id )
		->first();
        $teacher_id = $teacher->id;

        $sm_weekends = SmWeekend::orderBy('order', 'ASC')->where('active_status', 1)->get();
        $class_times = SmClassTime::where('type', 'class')->get();

        if (ApiBaseMethod::checkUrl($request->fullUrl())) {
            $data = [];
            $weekenD = SmWeekend::all();
            foreach ($weekenD as $row) {
                $data[$row->name] = DB::table('sm_class_routine_updates')
                    ->select('class_id','class_name','section_id','section_name','sm_class_times.period', 'sm_class_times.start_time', 'sm_class_times.end_time', 'sm_subjects.subject_name', 'sm_class_rooms.room_no')
                    ->join('sm_classes', 'sm_classes.id', '=', 'sm_class_routine_updates.class_id')
                    ->join('sm_sections', 'sm_sections.id', '=', 'sm_class_routine_updates.section_id')
                    ->join('sm_class_times', 'sm_class_times.id', '=', 'sm_class_routine_updates.class_period_id')
                    ->join('sm_subjects', 'sm_subjects.id', '=', 'sm_class_routine_updates.subject_id')
                    ->join('sm_class_rooms', 'sm_class_rooms.id', '=', 'sm_class_routine_updates.room_id')

                    ->where([
                        ['sm_class_routine_updates.teacher_id', $teacher_id], ['sm_class_routine_updates.day', $row->id],
                    ])->get();

            }

            return ApiBaseMethod::sendResponse($data, null);
        }
	}
	public function sectionRoutine(Request $request,$id, $class, $section){
		$teacher=DB::table('sm_staffs')
		->where('user_id','=',$id )
		->first();
        $teacher_id = $teacher->id;

        $sm_weekends = SmWeekend::orderBy('order', 'ASC')->where('active_status', 1)->get();
        $class_times = SmClassTime::where('type', 'class')->get();

        if (ApiBaseMethod::checkUrl($request->fullUrl())) {
            $data = [];
            $weekenD = SmWeekend::all();
            foreach ($weekenD as $row) {
                $data[$row->name] = DB::table('sm_class_routine_updates')
                    ->select('sm_class_times.period', 'sm_class_times.start_time', 'sm_class_times.end_time', 'sm_subjects.subject_name', 'sm_class_rooms.room_no')
                    ->join('sm_classes', 'sm_classes.id', '=', 'sm_class_routine_updates.class_id')
                    ->join('sm_sections', 'sm_sections.id', '=', 'sm_class_routine_updates.section_id')
                    ->join('sm_class_times', 'sm_class_times.id', '=', 'sm_class_routine_updates.class_period_id')
                    ->join('sm_subjects', 'sm_subjects.id', '=', 'sm_class_routine_updates.subject_id')
                    ->join('sm_class_rooms', 'sm_class_rooms.id', '=', 'sm_class_routine_updates.room_id')

                    ->where([
						['sm_class_routine_updates.teacher_id', $teacher_id],
						['sm_class_routine_updates.class_id', $class],
						['sm_class_routine_updates.section_id', $section],
						 ['sm_class_routine_updates.day', $row->id],
                    ])->get();

            }

            return ApiBaseMethod::sendResponse($data, null);
        }

	}
	public function classSection(Request $request,$id){

		$teacher=DB::table('sm_staffs')
		->where('user_id','=',$id )
		->first();
		$teacher_id = $teacher->id;
	
		if (ApiBaseMethod::checkUrl($request->fullUrl())) {
			$data=[];
			$teacher_classes=DB::table('sm_assign_subjects')
				->join('sm_classes','sm_classes.id','=','sm_assign_subjects.class_id' )
				->distinct('class_id')
				
				->where('teacher_id',$teacher_id )
				->get();
			foreach ($teacher_classes as $class) {
                $data[$class->class_name] = DB::table('sm_assign_subjects')
				->join('sm_subjects','sm_subjects.id','=','sm_assign_subjects.subject_id' )
				->join('sm_sections','sm_sections.id','=','sm_assign_subjects.section_id' )
				->select('section_name','subject_name')
				->distinct('section_id')
                    ->where([
						 ['sm_assign_subjects.class_id', $class->id],
                    ])->get();

            }

			return ApiBaseMethod::sendResponse($data, null);
        }

	}
	//Some Changes
	public function subjectsName(Request $request,$id){
		$teacher=DB::table('sm_staffs')
		->where('user_id','=',$id )
		->first();
		$teacher_id = $teacher->id;

		$subjectsName=DB::table('sm_assign_subjects')
				->join('sm_subjects','sm_subjects.id','=','sm_assign_subjects.subject_id' )
				->select('subject_id','subject_name','subject_code','subject_type' )
				->where('sm_assign_subjects.active_status',1 )
				->where('teacher_id',$teacher_id )
				->distinct('subject_id')
				->get();
				$subject_type='T=Theory, P=Practical';
		if (ApiBaseMethod::checkUrl($request->fullUrl())) {
			$data['subjectsName']=$subjectsName->toArray();
			$data['subject_type']=$subject_type;
			return ApiBaseMethod::sendResponse($data, null);
        }

	}
	public function addHomework(Request $request){

		// return $request->all();
		$request->validate([
			'class' => "required",
			'section' => "required",
			'subject' => "required",
			'assign_date' => "required",
			'submission_date' => "required",
			'description' => "required"
		]);


		$fileName = "";
		if ($request->file('homework_file') != "") {
			
			$file = $request->file('homework_file');
			$fileName = md5($file->getClientOriginalName() . time()) . "." . $file->getClientOriginalExtension();
			$file->move('public/uploads/homework/', $fileName);
			$fileName = 'public/uploads/homework/' . $fileName;
		}
		
		$homeworks = new SmHomework;
		$homeworks->class_id = $request->class;
		$homeworks->section_id = $request->section;
		$homeworks->subject_id = $request->subject;
		$homeworks->created_by = $request->teacher_id;
		$homeworks->homework_date = date('Y-m-d', strtotime($request->assign_date));
		$homeworks->submission_date = date('Y-m-d', strtotime($request->submission_date));
		//$homeworks->marks = $request->marks;
		$homeworks->description = $request->description;
		if ($fileName != "") {
			$homeworks->file = $fileName;
		}
	if (ApiBaseMethod::checkUrl($request->fullUrl())) {
		
		$results = $homeworks->save();

		return ApiBaseMethod::sendResponse($results, null);
	}
}
public function teacherMyAttendanceSearchAPI(Request $request, $id = null)
{

	$input = $request->all();

	$validator = Validator::make($input, [
		'month' => "required",
		'year' => "required",
	]);

	if ($validator->fails()) {
		if (ApiBaseMethod::checkUrl($request->fullUrl())) {
			return ApiBaseMethod::sendError('Validation Error.', $validator->errors());
		}
		return redirect()->back()->withErrors($validator)->withInput();
	}

	  $teacher = SmStaff::where('user_id', $id)->first();
   
	$year = $request->year;
	$month = $request->month;
	if($month<10){
		$month = '0'.$month;
	}
	$current_day = date('d');

	$days = cal_days_in_month(CAL_GREGORIAN, $month, $request->year);
	$days2 = cal_days_in_month(CAL_GREGORIAN, $month-1, $request->year);
	$previous_month = $month-1;
	$previous_date = $year.'-'.$previous_month.'-'.$days2; 

   

	$previousMonthDetails['date']= $previous_date;
	$previousMonthDetails['day']= $days2;
	$previousMonthDetails['week_name']=date('D', strtotime($previous_date));


	$attendances = SmStaffAttendance::where('student_id', $teacher->id)
	->where('attendance_date', 'like', '%'.$request->year . '-' . $month . '%')
	->select('attendance_type','attendance_date')
	->get();

	if (ApiBaseMethod::checkUrl($request->fullUrl())) {
		$data['attendances'] = $attendances;
		$data['previousMonthDetails'] = $previousMonthDetails;
		$data['days'] = $days;
		$data['year'] = $year;
		$data['month'] = $month;
		$data['current_day'] = $current_day;
		$data['status'] = 'Present: P, Late: L, Absent: A, Holiday: H, Half Day: F';
		return ApiBaseMethod::sendResponse($data, null);
	}
//Test
	//return view('backEnd.studentPanel.student_attendance', compact('attendances', 'days', 'year', 'month', 'current_day'));
}

}
